{ config, pkgs, ... }:

let
  catppuccinGtk = pkgs.catppuccin-gtk.override {
    variant = "mocha";                 
    accents = [ "lavender" ];          
    size = "standard";                 
  };
in {
  home.packages = with pkgs; [
    catppuccinGtk
    papirus-icon-theme
    gsettings-desktop-schemas
    glib
    dconf
  ];

  dconf.settings = {
    "org/gnome/desktop/interface" = {
      gtk-theme = "catppuccin-mocha-lavender-standard";
      icon-theme = "Papirus-Dark";  
      color-scheme = "prefer-dark";  
    };
  };

  home.sessionVariables = {
    GTK_THEME = "catppuccin-mocha-lavender-standard";
    XDG_CURRENT_DESKTOP = "Hyprland";
    XDG_SESSION_DESKTOP = "Hyprland";
  };

}
