{ config, pkgs, ... }:

{
  home.packages = with pkgs; [ mako ];

  services.mako = {
    enable = true;
    settings = {
      background-color = "#1e1e2e";
      border-color = "#1e1e2e"; # same as background to hide border
      border-size = 0; # no border to eliminate animation artifacts
      text-color = "#cdd6f4";
      progress-color = "#cba6f7"; # mauve accent
      font = "JetBrainsMono Nerd Font Bold 14";
      border-radius = 12; # keep rounded corners
      default-timeout = 6000;
      width = 420;
      height = 130;
      margin = "32,32,0,0";
      padding = "20";
      icons = true;
      
      max-visible = 5;
      sort = "-time";
      layer = "overlay"; # high layer for notifications
      ignore-timeout = false;
      anchor = "top-right";
      markup = true; # enable markup support for notification text
      actions = true; # enable notification actions
      group-by = "app-name"; # group notifications by application = 
    };
  };
}
