{ config, pkgs, lib, ... }:

let
  nvchadPath = "${config.home.homeDirectory}/.config/nvim";
  chadrcPath = "${nvchadPath}/lua/chadrc.lua";
in
{
  home.packages = with pkgs; [
    neovim
    ripgrep
    fd
    gcc
    python3
    git
    unzip
    nodejs
  ];

  home.activation.installNvChad = lib.hm.dag.entryAfter [ "writeBoundary" ] ''
    export PATH=${pkgs.git}/bin:$PATH

    if [ ! -d "${nvchadPath}" ]; then
      echo "🔧 Cloning NvChad..."
      ${pkgs.git}/bin/git clone https://github.com/NvChad/NvChad.git ${nvchadPath} --depth 1
    else
      echo "✅ NvChad already installed"
    fi

    # Create chadrc.lua in the correct location
    mkdir -p ${nvchadPath}/lua
    cat > ${chadrcPath} <<EOF
---@type ChadrcConfig
local M = {}

M.base46 = {
  theme = "catppuccin",
  theme_toggle = { "catppuccin", "onedark" },
  
  hl_override = {
    CursorLineNr = { fg = "lavender" },
    LineNr = { fg = "surface2" },
  },

  changed_themes = {
    catppuccin = {
      base_16 = {
        base05 = "#b4befe", -- lavender
      },
    },
  },
}

M.ui = {
  cmp = {
    style = "default", -- default/flat_light/flat_dark/atom/atom_colored
  },

  telescope = { style = "borderless" }, -- borderless / bordered
}

return M
EOF
  '';
}