{ config, pkgs, ... }:

{
  # Flatpak setup service (one-time setup)
  systemd.user.services.flatpak-setup = {
    Unit = {
      Description = "Setup Flatpak and install applications";
      After = [ "graphical-session.target" ];
    };
    Service = {
      Type = "oneshot";
      ExecStart = pkgs.writeShellScript "flatpak-setup" ''
        # Add Flathub repository if not already added
        ${pkgs.flatpak}/bin/flatpak remote-add --if-not-exists --user flathub https://dl.flathub.org/repo/flathub.flatpakrepo
        
        # Install Spotify if not already installed
        if ! ${pkgs.flatpak}/bin/flatpak list --user | grep -q com.spotify.Client; then
          ${pkgs.flatpak}/bin/flatpak install --user -y flathub com.spotify.Client
        fi
      '';
      RemainAfterExit = true;
    };
    Install = {
      WantedBy = [ "default.target" ];
    };
  };

  # Symlink Flatpak Spotify to local applications (for rofi visibility)
  home.file.".local/share/applications/com.spotify.Client.desktop".source = 
    config.lib.file.mkOutOfStoreSymlink "${config.home.homeDirectory}/.local/share/flatpak/exports/share/applications/com.spotify.Client.desktop";
}
