{ config, pkgs, ... }:

{
  programs.waybar.enable = true;

  home.packages = with pkgs; [
    playerctl  # For media control
    cava       # For audio visualization
  ];

  home.file.".config/waybar/config".text = ''
    {
      "layer": "top",
      "modules-left": ["hyprland/workspaces"],
      "modules-center": ["hyprland/window"],
      "modules-right": ["mpris", "cava", "network", "wireplumber", "cpu", "clock"],
      "hyprland/window": {
          "max-length": 50
      },
      "clock": {
          "format-alt": "{:%a, %d. %b  %H:%M}"
      },
      "network": {
        "format": "󰀂",
        "format-ethernet": "󰀂",
        "format-disconnected": "󰖪",
        "tooltip-format-ethernet": "⇣{bandwidthDownBytes}  ⇡{bandwidthUpBytes}",
        "tooltip-format-disconnected": "Disconnected",
        "interval": 3,
        "nospacing": 1,
        "on-click": "kitty -e sh -c 'nmcli; echo \"Press Enter to exit...\"; read'"
      },
      "wireplumber": {
        "format": "󰕾",
        "format-muted": "󰝟",
        "scroll-step": 5,
        "tooltip-format": "Playing at {volume}%",
        "max-volume": 150,
        "on-click": "pavucontrol",
        "on-click-right": "wpctl set-mute @DEFAULT_AUDIO_SINK@ toggle"
      },
      "cpu": {
        "interval": 5,
        "format": "󰍛",
        "on-click": "kitty -e btop"
      },
      "mpris": {
        "format": "{player_icon} {dynamic}",
        "format-paused": " ",
        "format-stopped": " ",
        "player-icons": {
          "default": "🎵",
          "mpv": "🎵",
          "spotify": "󰓇"
        },
        "status-icons": {
          "paused": "⏸",
          "playing": "▶"
        },
        "ignored-players": ["firefox"],
        "max-length": 55,
        "interval": 1,
        "on-click": "playerctl play-pause",
        "on-click-right": "playerctl next",
        "on-scroll-up": "wpctl set-volume @DEFAULT_AUDIO_SINK@ 5%+",
        "on-scroll-down": "wpctl set-volume @DEFAULT_AUDIO_SINK@ 5%-"
      },
      "cava": {
        "framerate": 30,
        "bars": 20,
        "format-icons" : [" ", "▁", "▂", "▃", "▄", "▅", "▆", "▇", "█" ],
        "hide_on_silence": true,
        "silence_threshold": 0.05,
        "input_delay": 1,
        "bar_delimiter": 0,
        "monstercat": true,
        "waves": false,
        "noise_reduction": 0.77,
        "method": "pulse"
      }
    }
  '';

  home.file.".config/waybar/style.css".text = ''
    /* Catppuccin Mocha-inspired Waybar style */
    * {
      font-family: "JetBrainsMono Nerd Font", "JetBrains Mono", monospace;
      font-size: 14px;
      color: #cdd6f4;
      background-color: transparent;
      border-radius: 0px;
    }

    window#waybar {
      background-color: rgba(30, 30, 46, 0.85);
      background-image: linear-gradient(
        to bottom,
        #89b4fa 0%,
        #cba6f7 100%
      );
      background-repeat: no-repeat;
      background-size: 100% 3px;
      background-position: bottom;
    }

    #clock {
      color: #b4befe;
      padding: 0 16px;
    }

    #workspaces button.active {
      background-color: rgba(137, 180, 250, 0.2);
      color: #89b4fa;
      border-radius: 0px;
    }

    #workspaces button {
      background-color: transparent;
      color: #cdd6f4;
      border: none;
      margin: 0 2px;
      padding: 0 8px;
      border-radius: 0px;
    }

    #window {
      color: #f5e0dc;
    }

    #network {
      color: #b4befe;
      padding: 0 12px;
    }

    #wireplumber {
      color: #b4befe;
      padding: 0 12px;
    }

    #cpu {
      color: #b4befe;
      padding: 0 12px;
    }

    #mpris {
      color: #b4befe;
      padding: 0 12px;
      margin: 0 4px;
      border-radius: 4px;
    }

    #mpris:hover {
      background-color: rgba(180, 190, 254, 0.1);
      border-radius: 4px;
    }

    #mpris.paused {
      opacity: 0;
      min-width: 0;
      padding: 0;
      margin: 0;
    }

    #cava {
      color: rgba(180, 190, 254, 0.8);
      padding: 0 8px;
      margin: 0 4px;
      font-family: "JetBrainsMono Nerd Font", monospace;
      font-size: 12px;
      background-color: transparent;
      border-radius: 4px;
      border: none;
      letter-spacing: 0px;
    }

    #cava:hover {
      background-color: rgba(180, 190, 254, 0.1);
    }

    #network:hover,
    #wireplumber:hover,
    #cpu:hover,
    #mpris:hover {
      background-color: rgba(205, 214, 244, 0.1);
      border-radius: 4px;
    }

    /* Tooltip styling */
    tooltip {
      background-color: rgba(30, 30, 46, 0.95);
      color: #cdd6f4;
      border: 1px solid rgba(137, 180, 250, 0.3);
      border-radius: 8px;
      padding: 8px 12px;
      font-size: 12px;
    }

    tooltip label {
      color: #cdd6f4;
    }
  '';

}
