{ config, pkgs, lib, ... }:

let
  icons = [ "logout" "shutdown" "reboot" ];
in {
  home.packages = with pkgs; [ wlogout ];

  # Layout
  xdg.configFile."wlogout/layout".text = ''
    {
      "label": "logout",
      "action": "hyprctl dispatch exit",
      "text": "Logout"
    }
    {
      "label": "shutdown",
      "action": "systemctl poweroff",
      "text": "Shutdown"
    }
    {
      "label": "reboot",
      "action": "systemctl reboot",
      "text": "Reboot"
    }
  '';
}
